<?php
/**
 *  Copyright 2012 GroupDocs.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */
class SharedApi {

	private $basePath = "https://api.groupdocs.com/v2.0";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

	public static function newInstance($apiClient) {
	  return new self($apiClient);
	}

    public function setBasePath($basePath) {
	  $this->basePath = $basePath;
	}
	  
	public function getBasePath() {
	  $this->basePath;
	}

  /**
	 * Download
	 * Download
   * guid, string: GUID (required)
   * fileName, string: File name (required)
   * render, bool: Render (optional)
   * @return stream
	 */

   public function Download($guid, $fileName, $render=null, FileStream $outFileStream) {
      if( $guid === null || $fileName === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/shared/files/{guid}?filename={fileName}&render={render}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($fileName !== null) {
  		  $queryParams['filename'] = $this->apiClient->toPathValue($fileName);
  		}
  		if($render !== null) {
  		  $queryParams['render'] = $this->apiClient->toPathValue($render);
  		}
  		if($guid !== null) {
  			$resourcePath = str_replace("{" . "guid" . "}",
  			                            $guid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetXml
	 * Get xml
   * guid, string: GUID (required)
   * @return stream
	 */

   public function GetXml($guid, FileStream $outFileStream) {
      if( $guid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/shared/files/{guid}/xml");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($guid !== null) {
  			$resourcePath = str_replace("{" . "guid" . "}",
  			                            $guid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetHtml
	 * Get html
   * guid, string: GUID (required)
   * @return stream
	 */

   public function GetHtml($guid, FileStream $outFileStream) {
      if( $guid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/shared/files/{guid}/html");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($guid !== null) {
  			$resourcePath = str_replace("{" . "guid" . "}",
  			                            $guid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetPackage
	 * Get package
   * path, string: Path (required)
   * @return stream
	 */

   public function GetPackage($path, FileStream $outFileStream) {
      if( $path === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/shared/packages/{*path}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($path !== null) {
  			$resourcePath = str_replace("{" . "path" . "}",
  			                            $path, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * LoginUser
	 * Logins user using user name and password
   * userName, string: User name (required)
   * body, string: Password (required)
   * @return UserInfoResponse
	 */

   public function LoginUser($userName, $body) {
      if( $userName === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/shared/users/{userName}/logins");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userName !== null) {
  			$resourcePath = str_replace("{" . "userName" . "}",
  			                            $userName, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'UserInfoResponse');
  	  return $responseObject;
      }
  
}

