<?php
/**
 *  Copyright 2012 GroupDocs.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */
class SignatureApi {

	private $basePath = "https://api.groupdocs.com/v2.0";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

	public static function newInstance($apiClient) {
	  return new self($apiClient);
	}

    public function setBasePath($basePath) {
	  $this->basePath = $basePath;
	}
	  
	public function getBasePath() {
	  $this->basePath;
	}

  /**
	 * GetSignatureTemplates
	 * Get templates
   * userId, string: User GUID (required)
   * page, int: Page number (optional)
   * records, int: Records count (optional)
   * documentGuid, string: Fitler templates by document originalMD5 (optional)
   * recipientName, string: Filter templates by recipient nickname (optional)
   * name, string: Filter templates by signatureTemplate name (optional)
   * tag, string: Filter templates by tag (optional)
   * @return SignatureTemplatesResponse
	 */

   public function GetSignatureTemplates($userId, $page=null, $records=null, $documentGuid=null, $recipientName=null, $name=null, $tag=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates?records={records}&page={page}&documentGuid={documentGuid}&recipientName={recipientName}&name={name}&tag={tag}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($page !== null) {
  		  $queryParams['page'] = $this->apiClient->toPathValue($page);
  		}
  		if($records !== null) {
  		  $queryParams['records'] = $this->apiClient->toPathValue($records);
  		}
  		if($documentGuid !== null) {
  		  $queryParams['documentGuid'] = $this->apiClient->toPathValue($documentGuid);
  		}
  		if($recipientName !== null) {
  		  $queryParams['recipientName'] = $this->apiClient->toPathValue($recipientName);
  		}
  		if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($tag !== null) {
  		  $queryParams['tag'] = $this->apiClient->toPathValue($tag);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplatesResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureTemplate
	 * Get template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * @return SignatureTemplateResponse
	 */

   public function GetSignatureTemplate($userId, $templateGuid) {
      if( $userId === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * CreateSignatureTemplate
	 * Create template
   * userId, string: User GUID (required)
   * name, string: Template name (required)
   * templateGuid, string: Template GUID of the template that will be used to create the new template (optional)
   * envelopeGuid, string: Envelope GUID of the envelope that will be used to create the new template (optional)
   * body, SignatureTemplateSettingsInfo: Settings of the template (optional)
   * @return SignatureTemplateResponse
	 */

   public function CreateSignatureTemplate($userId, $name, $templateGuid=null, $envelopeGuid=null, $body=null) {
      if( $userId === null || $name === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/template?name={name}&templateId={templateGuid}&envelopeId={envelopeGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($templateGuid !== null) {
  		  $queryParams['templateId'] = $this->apiClient->toPathValue($templateGuid);
  		}
  		if($envelopeGuid !== null) {
  		  $queryParams['envelopeId'] = $this->apiClient->toPathValue($envelopeGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureTemplate
	 * Modify template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * body, SignatureTemplateSettingsInfo: Settings of the template (optional)
   * @return SignatureTemplateResponse
	 */

   public function ModifySignatureTemplate($userId, $templateGuid, $body=null) {
      if( $userId === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * RenameSignatureTemplate
	 * Rename template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * name, string: New template name (required)
   * @return SignatureTemplateResponse
	 */

   public function RenameSignatureTemplate($userId, $templateGuid, $name) {
      if( $userId === null || $templateGuid === null || $name === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}?name={name}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureTemplate
	 * Delete template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureTemplate($userId, $templateGuid) {
      if( $userId === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureTemplateRecipient
	 * Add recipient to the template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * nickname, string: Nickname of the recipient (required)
   * roleGuid, string: Role GUID (required)
   * order, int: Display order of the recipient (optional)
   * @return SignatureTemplateRecipientResponse
	 */

   public function AddSignatureTemplateRecipient($userId, $templateGuid, $nickname, $roleGuid, $order=null) {
      if( $userId === null || $templateGuid === null || $nickname === null || $roleGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/recipient?nickname={nickname}&role={roleGuid}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($nickname !== null) {
  		  $queryParams['nickname'] = $this->apiClient->toPathValue($nickname);
  		}
  		if($roleGuid !== null) {
  		  $queryParams['role'] = $this->apiClient->toPathValue($roleGuid);
  		}
  		if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateRecipientResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureTemplateRecipients
	 * Get template recipients
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * @return SignatureTemplateRecipientsResponse
	 */

   public function GetSignatureTemplateRecipients($userId, $templateGuid) {
      if( $userId === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/recipients");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateRecipientsResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureTemplateRecipient
	 * Remove recipient from template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureTemplateRecipient($userId, $templateGuid, $recipientGuid) {
      if( $userId === null || $templateGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/recipients/{recipientGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureTemplateRecipient
	 * Update template recipient
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * nickname, string: Nickname of the recipient (required)
   * roleGuid, string: Role GUID (required)
   * order, string: Display order of the recipient (optional)
   * @return SignatureTemplateRecipientResponse
	 */

   public function ModifySignatureTemplateRecipient($userId, $templateGuid, $recipientGuid, $nickname, $roleGuid, $order=null) {
      if( $userId === null || $templateGuid === null || $recipientGuid === null || $nickname === null || $roleGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/recipient/{recipientGuid}?nickname={nickname}&role={roleGuid}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($nickname !== null) {
  		  $queryParams['nickname'] = $this->apiClient->toPathValue($nickname);
  		}
  		if($roleGuid !== null) {
  		  $queryParams['role'] = $this->apiClient->toPathValue($roleGuid);
  		}
  		if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateRecipientResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureTemplateDocument
	 * Add document to template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (required)
   * order, int: Display order of the document (optional)
   * parseFields, bool: Try to parse fields in document (optional)
   * @return SignatureTemplateDocumentResponse
	 */

   public function AddSignatureTemplateDocument($userId, $templateGuid, $documentGuid, $order=null, $parseFields=null) {
      if( $userId === null || $templateGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/document/{documentGuid}?parseFields={parseFields}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($parseFields !== null) {
  		  $queryParams['parseFields'] = $this->apiClient->toPathValue($parseFields);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureTemplateDocuments
	 * Get documents in template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * @return SignatureTemplateDocumentsResponse
	 */

   public function GetSignatureTemplateDocuments($userId, $templateGuid) {
      if( $userId === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/documents");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateDocumentsResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureTemplateDocument
	 * Remove document from template
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureTemplateDocument($userId, $templateGuid, $documentGuid) {
      if( $userId === null || $templateGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureTemplateField
	 * Add signature template field
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureTemplateFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureTemplateFieldResponse
	 */

   public function AddSignatureTemplateField($userId, $templateGuid, $documentGuid, $recipientGuid, $fieldGuid, $body=null) {
      if( $userId === null || $templateGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateFieldResponse');
  	  return $responseObject;
      }
  /**
	 * AssignSignatureTemplateField
	 * Assign signature template field
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureTemplateAssignFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureTemplateFieldResponse
	 */

   public function AssignSignatureTemplateField($userId, $templateGuid, $documentGuid, $fieldGuid, $body=null) {
      if( $userId === null || $templateGuid === null || $documentGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateFieldResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureTemplateField
	 * Modify signature template field
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureTemplateFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureTemplateFieldResponse
	 */

   public function ModifySignatureTemplateField($userId, $templateGuid, $documentGuid, $recipientGuid, $fieldGuid, $body=null) {
      if( $userId === null || $templateGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/recipientGuid/{recipientGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateFieldResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureTemplateFieldLocation
	 * Delete signature template field location
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureTemplateFieldLocation($userId, $templateGuid, $fieldGuid, $locationGuid) {
      if( $userId === null || $templateGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/fields/{fieldGuid}/locations/{locationGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureTemplateFieldLocation
	 * Modify signature template field location
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * body, SignatureTemplateFieldLocationSettingsInfo: Settings of the field location (optional)
   * @return SignatureTemplateFieldResponse
	 */

   public function ModifySignatureTemplateFieldLocation($userId, $templateGuid, $documentGuid, $recipientGuid, $fieldGuid, $locationGuid, $body=null) {
      if( $userId === null || $templateGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/recipient/{recipientGuid}/fields/{fieldGuid}/locations/{locationGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateFieldResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureTemplateFields
	 * Get template fields
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Document GUID (optional)
   * recipientGuid, string: Recipient GUID (optional)
   * fieldGuid, string: Field GUID (optional)
   * @return SignatureTemplateFieldsResponse
	 */

   public function GetSignatureTemplateFields($userId, $templateGuid, $documentGuid=null, $recipientGuid=null, $fieldGuid=null) {
      if( $userId === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/fields?document={documentGuid}&recipient={recipientGuid}&field={fieldGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($documentGuid !== null) {
  		  $queryParams['document'] = $this->apiClient->toPathValue($documentGuid);
  		}
  		if($recipientGuid !== null) {
  		  $queryParams['recipient'] = $this->apiClient->toPathValue($recipientGuid);
  		}
  		if($fieldGuid !== null) {
  		  $queryParams['field'] = $this->apiClient->toPathValue($fieldGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureTemplateField
	 * Delete signature template field
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * fieldGuid, string: Field GUID (required)
   * @return SignatureTemplateResponse
	 */

   public function DeleteSignatureTemplateField($userId, $templateGuid, $fieldGuid) {
      if( $userId === null || $templateGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/fields/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureTemplateResources
	 * Get template resources
   * userId, string: User GUID (required)
   * @return SignatureTemplateResourcesResponse
	 */

   public function GetSignatureTemplateResources($userId) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/resources");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateResourcesResponse');
  	  return $responseObject;
      }
  /**
	 * RenameSignatureTemplateDocument
	 * Rename signature template document
   * userId, string: User GUID (required)
   * templateGuid, string: Template GUID (required)
   * documentGuid, string: Template Document GUID (required)
   * newName, string: New name of the document (optional)
   * @return SignatureTemplateDocumentResponse
	 */

   public function RenameSignatureTemplateDocument($userId, $templateGuid, $documentGuid, $newName=null) {
      if( $userId === null || $templateGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/templates/{templateGuid}/document/{documentGuid}?newName={newName}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($newName !== null) {
  		  $queryParams['newName'] = $this->apiClient->toPathValue($newName);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureTemplateDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * GetContacts
	 * Get contacts
   * userId, string: User GUID (required)
   * page, int: Page number (optional)
   * records, int: Records count to be returned (optional)
   * firstName, string: Filter by firstName (optional)
   * lastName, string: Filter by lastName (optional)
   * email, string: Filter by email (optional)
   * useAnd, bool: Filter uses AND instead of default OR between parameters (optional)
   * @return SignatureContactsResponse
	 */

   public function GetContacts($userId, $page=null, $records=null, $firstName=null, $lastName=null, $email=null, $useAnd=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/contacts?firstName={firstName}&lastName={lastName}&email={email}&records={records}&page={page}&useAnd={useAnd}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($page !== null) {
  		  $queryParams['page'] = $this->apiClient->toPathValue($page);
  		}
  		if($records !== null) {
  		  $queryParams['records'] = $this->apiClient->toPathValue($records);
  		}
  		if($firstName !== null) {
  		  $queryParams['firstName'] = $this->apiClient->toPathValue($firstName);
  		}
  		if($lastName !== null) {
  		  $queryParams['lastName'] = $this->apiClient->toPathValue($lastName);
  		}
  		if($email !== null) {
  		  $queryParams['email'] = $this->apiClient->toPathValue($email);
  		}
  		if($useAnd !== null) {
  		  $queryParams['useAnd'] = $this->apiClient->toPathValue($useAnd);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureContactsResponse');
  	  return $responseObject;
      }
  /**
	 * AddContact
	 * Add contact
   * userId, string: User GUID (required)
   * body, SignatureContactSettingsInfo: Contact data (required)
   * @return SignatureContactResponse
	 */

   public function AddContact($userId, $body) {
      if( $userId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/contact");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureContactResponse');
  	  return $responseObject;
      }
  /**
	 * ModifyContact
	 * Update contact
   * userId, string: User GUID (required)
   * contactGuid, string: Contact GUID (required)
   * body, SignatureContactSettingsInfo: Contact data (optional)
   * @return SignatureContactResponse
	 */

   public function ModifyContact($userId, $contactGuid, $body=null) {
      if( $userId === null || $contactGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/contacts/{contactGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($contactGuid !== null) {
  			$resourcePath = str_replace("{" . "contactGuid" . "}",
  			                            $contactGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureContactResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteContact
	 * Delete contact
   * userId, string: User GUID (required)
   * contactGuid, string: Contact GUID (required)
   * @return SignatureContactResponse
	 */

   public function DeleteContact($userId, $contactGuid) {
      if( $userId === null || $contactGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/contacts/{contactGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($contactGuid !== null) {
  			$resourcePath = str_replace("{" . "contactGuid" . "}",
  			                            $contactGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureContactResponse');
  	  return $responseObject;
      }
  /**
	 * ImportContacts
	 * Import contacts
   * userId, string: User GUID (required)
   * body, List[SignatureContactSettingsInfo]: Array of SignatureContactSettingsInfo (optional)
   * @return SignatureContactsImportResponse
	 */

   public function ImportContacts($userId, $body=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/contacts");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureContactsImportResponse');
  	  return $responseObject;
      }
  /**
	 * AddContactIntegration
	 * Add Contact Integration Authorization
   * userId, string: User GUID (required)
   * body, SignatureContactIntegrationSettings: Authorization settings (optional)
   * @return SignatureStatusResponse
	 */

   public function AddContactIntegration($userId, $body=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/integration");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * SignDocument
	 * Sign document
   * userId, string: User GUID (required)
   * body, SignatureSignDocumentSettingsInfo: Settings of the signing document (optional)
   * @return SignatureSignDocumentResponse
	 */

   public function SignDocument($userId, $body=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/sign");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureSignDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignDocumentStatus
	 * Get sign documents status
   * userId, string: User GUID (required)
   * jobGuid, string: Job GUID (required)
   * @return SignatureSignDocumentStatusResponse
	 */

   public function GetSignDocumentStatus($userId, $jobGuid) {
      if( $userId === null || $jobGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/documents/{jobGuid}/status");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($jobGuid !== null) {
  			$resourcePath = str_replace("{" . "jobGuid" . "}",
  			                            $jobGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureSignDocumentStatusResponse');
  	  return $responseObject;
      }
  /**
	 * ArchiveSignatureEnvelope
	 * Archive envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureStatusResponse
	 */

   public function ArchiveSignatureEnvelope($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/archive");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetEnvelopeAuditLogs
	 * Get envelope audit logs
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureEnvelopeAuditLogsResponse
	 */

   public function GetEnvelopeAuditLogs($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/logs");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeAuditLogsResponse');
  	  return $responseObject;
      }
  /**
	 * CreateSignatureEnvelope
	 * Create signature envelope
   * userId, string: User GUID (required)
   * name, string: Envelope name (optional)
   * templateGuid, string: A templateGuid of the template which will be used to created the new envelope (optional)
   * envelopeGuid, string: A envelopeGuid of the envelope which will be used to created the new envelope (optional)
   * documentGuid, string: A documentGuid of the document which will be added to the new created envelope (optional)
   * parseFields, bool: Try to parse fields in document (optional)
   * body, SignatureEnvelopeSettingsInfo: Settings of the new envelope (optional)
   * @return SignatureEnvelopeResponse
	 */

   public function CreateSignatureEnvelope($userId, $name=null, $templateGuid=null, $envelopeGuid=null, $documentGuid=null, $parseFields=null, $body=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelope?name={name}&templateId={templateGuid}&envelopeId={envelopeGuid}&documentId={documentGuid}&parseFields={parseFields}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($templateGuid !== null) {
  		  $queryParams['templateId'] = $this->apiClient->toPathValue($templateGuid);
  		}
  		if($envelopeGuid !== null) {
  		  $queryParams['envelopeId'] = $this->apiClient->toPathValue($envelopeGuid);
  		}
  		if($documentGuid !== null) {
  		  $queryParams['documentId'] = $this->apiClient->toPathValue($documentGuid);
  		}
  		if($parseFields !== null) {
  		  $queryParams['parseFields'] = $this->apiClient->toPathValue($parseFields);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResponse');
  	  return $responseObject;
      }
  /**
	 * DeclineEnvelope
	 * Decline envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeclineEnvelope($userId, $envelopeGuid, $recipientGuid) {
      if( $userId === null || $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}/decline");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * DelegateEnvelopeRecipient
	 * Delegate envelope recipient
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * recipientEmail, string: Delegated recipient email (required)
   * recipientFirstName, string: Delegated recipient first name (required)
   * recipientLastName, string: Delegated recipient last name (required)
   * @return SignatureStatusResponse
	 */

   public function DelegateEnvelopeRecipient($userId, $envelopeGuid, $recipientGuid, $recipientEmail, $recipientFirstName, $recipientLastName) {
      if( $userId === null || $envelopeGuid === null || $recipientGuid === null || $recipientEmail === null || $recipientFirstName === null || $recipientLastName === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}/delegate?email={recipientEmail}&firstname={recipientFirstName}&lastname={recipientLastName}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($recipientEmail !== null) {
  		  $queryParams['email'] = $this->apiClient->toPathValue($recipientEmail);
  		}
  		if($recipientFirstName !== null) {
  		  $queryParams['firstname'] = $this->apiClient->toPathValue($recipientFirstName);
  		}
  		if($recipientLastName !== null) {
  		  $queryParams['lastname'] = $this->apiClient->toPathValue($recipientLastName);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureEnvelope
	 * Delete signature envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureEnvelope($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureEnvelopeDocument
	 * Add document in envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * order, int: Document order (optional)
   * parseFields, bool: Try to parse fields in document (optional)
   * @return SignatureEnvelopeDocumentResponse
	 */

   public function AddSignatureEnvelopeDocument($userId, $envelopeGuid, $documentGuid, $order=null, $parseFields=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/document/{documentGuid}?parseFields={parseFields}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($parseFields !== null) {
  		  $queryParams['parseFields'] = $this->apiClient->toPathValue($parseFields);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignedEnvelopeDocument
	 * Get signed envelope document
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * @return stream
	 */

   public function GetSignedEnvelopeDocument($userId, $envelopeGuid, $documentGuid, FileStream $outFileStream) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/document/{documentGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * DeleteSignatureEnvelopeDocument
	 * Delete document from envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureEnvelopeDocument($userId, $envelopeGuid, $documentGuid) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelopeDocuments
	 * Get documents in envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureEnvelopeDocumentsResponse
	 */

   public function GetSignatureEnvelopeDocuments($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeDocumentsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignedEnvelopeDocuments
	 * Get signed envelope documents
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return stream
	 */

   public function GetSignedEnvelopeDocuments($userId, $envelopeGuid, FileStream $outFileStream) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/get");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * AddSignatureEnvelopeField
	 * Add signature field for document in envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureEnvelopeFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureEnvelopeFieldsResponse
	 */

   public function AddSignatureEnvelopeField($userId, $envelopeGuid, $documentGuid, $recipientGuid, $fieldGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * AssignSignatureEnvelopeField
	 * Assign signature envelope field
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureEnvelopeAssignFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureEnvelopeFieldResponse
	 */

   public function AssignSignatureEnvelopeField($userId, $envelopeGuid, $documentGuid, $fieldGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldResponse');
  	  return $responseObject;
      }
  /**
	 * FillEnvelopeField
	 * Fill envelope field
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * signatureGuid, string: SignatureId GUID (optional)
   * body, stream: Data to be placed in field (optional)
   * @return SignatureEnvelopeFieldResponse
	 */

   public function FillEnvelopeField($userId, $envelopeGuid, $documentGuid, $recipientGuid, $fieldGuid, $signatureGuid=null, $body=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}?signatureId={signatureGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($signatureGuid !== null) {
  		  $queryParams['signatureId'] = $this->apiClient->toPathValue($signatureGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureEnvelopeFieldLocation
	 * Modify signature envelope field location
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * body, SignatureEnvelopeFieldLocationSettingsInfo: Settings of the field location (optional)
   * @return SignatureEnvelopeFieldResponse
	 */

   public function ModifySignatureEnvelopeFieldLocation($userId, $envelopeGuid, $documentGuid, $recipientGuid, $fieldGuid, $locationGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/fields/{fieldGuid}/locations/{locationGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureEnvelopeFieldLocation
	 * Remove signature envelope field location
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureEnvelopeFieldLocation($userId, $envelopeGuid, $fieldGuid, $locationGuid) {
      if( $userId === null || $envelopeGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/fields/{fieldGuid}/locations/{locationGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureEnvelopeField
	 * Modify signature envelope field
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureEnvelopeFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureEnvelopeFieldResponse
	 */

   public function ModifySignatureEnvelopeField($userId, $envelopeGuid, $documentGuid, $recipientGuid, $fieldGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipientGuid/{recipientGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureEnvelopeField
	 * Delete signature envelope field
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * fieldGuid, string: Field GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureEnvelopeField($userId, $envelopeGuid, $fieldGuid) {
      if( $userId === null || $envelopeGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/fields/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelopeFields
	 * Get signature field for document in envelope per recipient
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (optional)
   * recipientGuid, string: Recipient GUID (optional)
   * fieldGuid, string: Field GUID (optional)
   * @return SignatureEnvelopeFieldsResponse
	 */

   public function GetSignatureEnvelopeFields($userId, $envelopeGuid, $documentGuid=null, $recipientGuid=null, $fieldGuid=null) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/fields?document={documentGuid}&recipient={recipientGuid}&field={fieldGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($documentGuid !== null) {
  		  $queryParams['document'] = $this->apiClient->toPathValue($documentGuid);
  		}
  		if($recipientGuid !== null) {
  		  $queryParams['recipient'] = $this->apiClient->toPathValue($recipientGuid);
  		}
  		if($fieldGuid !== null) {
  		  $queryParams['field'] = $this->apiClient->toPathValue($fieldGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelope
	 * Get signature envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureEnvelopeResponse
	 */

   public function GetSignatureEnvelope($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureEnvelope
	 * Modify signature envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * body, SignatureEnvelopeSettingsInfo: Settings of the envelope (optional)
   * @return SignatureEnvelopeResponse
	 */

   public function ModifySignatureEnvelope($userId, $envelopeGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureEnvelopeRecipient
	 * Add signature envelope recipient
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * recipientEmail, string: Recipient email (required)
   * recipientFirstName, string: Recipient first name (required)
   * recipientLastName, string: Recipient last name (required)
   * roleGuid, string: Recipient role GUID (required)
   * order, int: Recipient order (optional)
   * @return SignatureEnvelopeRecipientResponse
	 */

   public function AddSignatureEnvelopeRecipient($userId, $envelopeGuid, $recipientEmail, $recipientFirstName, $recipientLastName, $roleGuid, $order=null) {
      if( $userId === null || $envelopeGuid === null || $recipientEmail === null || $recipientFirstName === null || $recipientLastName === null || $roleGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipient?email={recipientEmail}&firstname={recipientFirstName}&lastname={recipientLastName}&role={roleGuid}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($recipientEmail !== null) {
  		  $queryParams['email'] = $this->apiClient->toPathValue($recipientEmail);
  		}
  		if($recipientFirstName !== null) {
  		  $queryParams['firstname'] = $this->apiClient->toPathValue($recipientFirstName);
  		}
  		if($recipientLastName !== null) {
  		  $queryParams['lastname'] = $this->apiClient->toPathValue($recipientLastName);
  		}
  		if($roleGuid !== null) {
  		  $queryParams['role'] = $this->apiClient->toPathValue($roleGuid);
  		}
  		if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeRecipientResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureEnvelopeRecipient
	 * Modify signature envelope recipient
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * recipientEmail, string: Recipient email (required)
   * recipientFirstName, string: Recipient first name (required)
   * recipientLastName, string: Recipient last name (required)
   * roleGuid, string: Recipient role GUID (required)
   * order, int: Recipient order (optional)
   * @return SignatureEnvelopeRecipientResponse
	 */

   public function ModifySignatureEnvelopeRecipient($userId, $envelopeGuid, $recipientGuid, $recipientEmail, $recipientFirstName, $recipientLastName, $roleGuid, $order=null) {
      if( $userId === null || $envelopeGuid === null || $recipientGuid === null || $recipientEmail === null || $recipientFirstName === null || $recipientLastName === null || $roleGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}?email={recipientEmail}&firstname={recipientFirstName}&lastname={recipientLastName}&role={roleGuid}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($recipientEmail !== null) {
  		  $queryParams['email'] = $this->apiClient->toPathValue($recipientEmail);
  		}
  		if($recipientFirstName !== null) {
  		  $queryParams['firstname'] = $this->apiClient->toPathValue($recipientFirstName);
  		}
  		if($recipientLastName !== null) {
  		  $queryParams['lastname'] = $this->apiClient->toPathValue($recipientLastName);
  		}
  		if($roleGuid !== null) {
  		  $queryParams['role'] = $this->apiClient->toPathValue($roleGuid);
  		}
  		if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeRecipientResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureEnvelopeRecipient
	 * Delete signature envelope recipient
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureEnvelopeRecipient($userId, $envelopeGuid, $recipientGuid) {
      if( $userId === null || $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipients/{recipientGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelopeRecipients
	 * Get signature envelope recipients
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureEnvelopeRecipientsResponse
	 */

   public function GetSignatureEnvelopeRecipients($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipients");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeRecipientsResponse');
  	  return $responseObject;
      }
  /**
	 * RenameSignatureEnvelope
	 * Rename signature envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * name, string: New envelope name (required)
   * @return SignatureEnvelopeResponse
	 */

   public function RenameSignatureEnvelope($userId, $envelopeGuid, $name) {
      if( $userId === null || $envelopeGuid === null || $name === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}?name={name}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResponse');
  	  return $responseObject;
      }
  /**
	 * RestartExpiredSignatureEnvelope
	 * Restart expired envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureStatusResponse
	 */

   public function RestartExpiredSignatureEnvelope($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/restart");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * SignatureEnvelopeSend
	 * Send envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * body, WebhookInfo: Webhook Callback Url (optional)
   * @return SignatureEnvelopeSendResponse
	 */

   public function SignatureEnvelopeSend($userId, $envelopeGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/send");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeSendResponse');
  	  return $responseObject;
      }
  /**
	 * SignEnvelope
	 * Sign envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * body, SignatureSignEnvelopeSettingsInfo: Sign settings (optional)
   * @return SignatureStatusResponse
	 */

   public function SignEnvelope($userId, $envelopeGuid, $recipientGuid, $body=null) {
      if( $userId === null || $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}/sign");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelopes
	 * Get signature envelopes
   * userId, string: User GUID (required)
   * statusId, int: Filter envelopes by statusId (optional)
   * page, int: Show records for page number (optional)
   * records, int: Show records count (optional)
   * originalDocumentMD5, string: Filter envelopes by original document md5 checksum (optional)
   * recipientEmail, string: Filter envelopes by recipient email (optional)
   * DateTime, string: Filter envelopes by date (optional)
   * name, string: Filter envelopes by name (optional)
   * tag, string: Filter envelopes by tag (optional)
   * @return SignatureEnvelopesResponse
	 */

   public function GetSignatureEnvelopes($userId, $statusId=null, $page=null, $records=null, $originalDocumentMD5=null, $recipientEmail=null, $DateTime=null, $name=null, $tag=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes?statusId={statusId}&records={records}&page={page}&document={originalDocumentMD5}&recipient={recipientEmail}&date={date}&name={name}&tag={tag}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($statusId !== null) {
  		  $queryParams['statusId'] = $this->apiClient->toPathValue($statusId);
  		}
  		if($page !== null) {
  		  $queryParams['page'] = $this->apiClient->toPathValue($page);
  		}
  		if($records !== null) {
  		  $queryParams['records'] = $this->apiClient->toPathValue($records);
  		}
  		if($originalDocumentMD5 !== null) {
  		  $queryParams['document'] = $this->apiClient->toPathValue($originalDocumentMD5);
  		}
  		if($recipientEmail !== null) {
  		  $queryParams['recipient'] = $this->apiClient->toPathValue($recipientEmail);
  		}
  		if($DateTime !== null) {
  		  $queryParams['date'] = $this->apiClient->toPathValue($DateTime);
  		}
  		if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($tag !== null) {
  		  $queryParams['tag'] = $this->apiClient->toPathValue($tag);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopesResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelopeResources
	 * Get envelope resources
   * userId, string: User GUID (required)
   * statusIds, string: Envelope status identifier - comma separated list (optional)
   * @return SignatureEnvelopeResourcesResponse
	 */

   public function GetSignatureEnvelopeResources($userId, $statusIds=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/resources?statusIds={statusIds}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($statusIds !== null) {
  		  $queryParams['statusIds'] = $this->apiClient->toPathValue($statusIds);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResourcesResponse');
  	  return $responseObject;
      }
  /**
	 * GetRecipientSignatureEnvelopes
	 * Get signature envelopes where the user is recipient
   * userId, string: User GUID (required)
   * statusId, string: Filter envelopes by statusId (optional)
   * page, int: Show records for page number (optional)
   * records, int: Show records count (optional)
   * @return SignatureEnvelopesResponse
	 */

   public function GetRecipientSignatureEnvelopes($userId, $statusId=null, $page=null, $records=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/recipient?statusId={statusId}&records={records}&page={page}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($statusId !== null) {
  		  $queryParams['statusId'] = $this->apiClient->toPathValue($statusId);
  		}
  		if($page !== null) {
  		  $queryParams['page'] = $this->apiClient->toPathValue($page);
  		}
  		if($records !== null) {
  		  $queryParams['records'] = $this->apiClient->toPathValue($records);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopesResponse');
  	  return $responseObject;
      }
  /**
	 * RenameSignatureEnvelopeDocument
	 * Rename signature envelope document
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * newName, string: New name of the document (optional)
   * @return SignatureEnvelopeDocumentResponse
	 */

   public function RenameSignatureEnvelopeDocument($userId, $envelopeGuid, $documentGuid, $newName=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/document/{documentGuid}?newName={newName}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($newName !== null) {
  		  $queryParams['newName'] = $this->apiClient->toPathValue($newName);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * CancelSignatureEnvelope
	 * Cancel envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureStatusResponse
	 */

   public function CancelSignatureEnvelope($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/cancel");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * RetrySignEnvelope
	 * Retry sign envelope
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureStatusResponse
	 */

   public function RetrySignEnvelope($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/retry");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateEnvelopeFromTemplate
	 * Update envelope from template
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * templateGuid, string: Template GUID (required)
   * @return SignatureEnvelopeResponse
	 */

   public function UpdateEnvelopeFromTemplate($userId, $envelopeGuid, $templateGuid) {
      if( $userId === null || $envelopeGuid === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/templates/{templateGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureEnvelopeFieldLocationOrder
	 * Modify signature envelope field location
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * order, int: Location order (optional)
   * @return SignatureEnvelopeFieldResponse
	 */

   public function ModifySignatureEnvelopeFieldLocationOrder($userId, $envelopeGuid, $documentGuid, $recipientGuid, $fieldGuid, $locationGuid, $order=null) {
      if( $userId === null || $envelopeGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/fields/{fieldGuid}/locations/{locationGuid}?order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldResponse');
  	  return $responseObject;
      }
  /**
	 * ResendSignatureEnvelopeEmailNotification
	 * Resend envelope email notification
   * userId, string: User GUID (required)
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureStatusResponse
	 */

   public function ResendSignatureEnvelopeEmailNotification($userId, $envelopeGuid) {
      if( $userId === null || $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/envelopes/{envelopeGuid}/resend-notification");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetFieldsList
	 * Get signature fields
   * userId, string: User GUID (required)
   * fieldGuid, string: Filter fields by id (optional)
   * @return SignatureFieldsResponse
	 */

   public function GetFieldsList($userId, $fieldGuid=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/fields?id={fieldGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($fieldGuid !== null) {
  		  $queryParams['id'] = $this->apiClient->toPathValue($fieldGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * CreateSignatureField
	 * Create signature field
   * userId, string: User GUID (required)
   * body, SignatureFieldSettingsInfo: Settings of the new field (optional)
   * @return SignatureFieldResponse
	 */

   public function CreateSignatureField($userId, $body=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/field");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFieldResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureField
	 * Modify signature field
   * userId, string: User GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureFieldResponse
	 */

   public function ModifySignatureField($userId, $fieldGuid, $body=null) {
      if( $userId === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/fields/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFieldResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureField
	 * Delete signature field
   * userId, string: User GUID (required)
   * fieldGuid, string: Field GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureField($userId, $fieldGuid) {
      if( $userId === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/fields/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * ArchiveSignatureForm
	 * Archive signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureStatusResponse
	 */

   public function ArchiveSignatureForm($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/archive");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * CompleteSignatureForm
	 * Complete signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureStatusResponse
	 */

   public function CompleteSignatureForm($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/complete");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * CreateSignatureForm
	 * Create signature form
   * userId, string: User GUID (required)
   * name, string: Form name (optional)
   * templateGuid, string: A templateGuid of the template which will be used to created the new form (optional)
   * assemblyGuid, string: A guid of the assembly which will be used to created the new form (optional)
   * formGuid, string: A formGuid of the form which will be used to created the new form (optional)
   * body, SignatureFormSettingsInfo: Settings of the new form (optional)
   * @return SignatureFormResponse
	 */

   public function CreateSignatureForm($userId, $name=null, $templateGuid=null, $assemblyGuid=null, $formGuid=null, $body=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/form?name={name}&templateId={templateGuid}&assemblyId={assemblyGuid}&formId={formGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($templateGuid !== null) {
  		  $queryParams['templateId'] = $this->apiClient->toPathValue($templateGuid);
  		}
  		if($assemblyGuid !== null) {
  		  $queryParams['assemblyId'] = $this->apiClient->toPathValue($assemblyGuid);
  		}
  		if($formGuid !== null) {
  		  $queryParams['formId'] = $this->apiClient->toPathValue($formGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureForm
	 * Delete signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureForm($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureFormDocument
	 * Add document in form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * order, int: Document order (optional)
   * parseFields, bool: Try to parse fields in document (optional)
   * @return SignatureFormDocumentResponse
	 */

   public function AddSignatureFormDocument($userId, $formGuid, $documentGuid, $order=null, $parseFields=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/document/{documentGuid}?parseFields={parseFields}&order={order}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($order !== null) {
  		  $queryParams['order'] = $this->apiClient->toPathValue($order);
  		}
  		if($parseFields !== null) {
  		  $queryParams['parseFields'] = $this->apiClient->toPathValue($parseFields);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureFormDocument
	 * Delete document from form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureFormDocument($userId, $formGuid, $documentGuid) {
      if( $userId === null || $formGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents/{documentGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureFormDocuments
	 * Get documents in form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureFormDocumentsResponse
	 */

   public function GetSignatureFormDocuments($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormDocumentsResponse');
  	  return $responseObject;
      }
  /**
	 * AddSignatureFormField
	 * Add signature field for document in form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureFormFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureFormFieldResponse
	 */

   public function AddSignatureFormField($userId, $formGuid, $documentGuid, $fieldGuid, $body=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureFormFieldLocation
	 * Modify signature form field location
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * body, SignatureFormFieldLocationSettingsInfo: Settings of the field location (optional)
   * @return SignatureFormFieldResponse
	 */

   public function ModifySignatureFormFieldLocation($userId, $formGuid, $documentGuid, $fieldGuid, $locationGuid, $body=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/fields/{fieldGuid}/locations/{locationGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureFormFieldLocation
	 * Remove signature form field location
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * fieldGuid, string: Field GUID (required)
   * locationGuid, string: Field location GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureFormFieldLocation($userId, $formGuid, $fieldGuid, $locationGuid) {
      if( $userId === null || $formGuid === null || $fieldGuid === null || $locationGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/fields/{fieldGuid}/locations/{locationGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($locationGuid !== null) {
  			$resourcePath = str_replace("{" . "locationGuid" . "}",
  			                            $locationGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureFormField
	 * Modify signature form field
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, SignatureFormFieldSettingsInfo: Settings of the field (optional)
   * @return SignatureFormFieldResponse
	 */

   public function ModifySignatureFormField($userId, $formGuid, $documentGuid, $fieldGuid, $body=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignatureFormField
	 * Delete signature form field
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * fieldGuid, string: Field GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignatureFormField($userId, $formGuid, $fieldGuid) {
      if( $userId === null || $formGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/fields/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureFormFields
	 * Get form fields for document in form per participant
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * fieldGuid, string: Field GUID (optional)
   * @return SignatureFormFieldsResponse
	 */

   public function GetSignatureFormFields($userId, $formGuid, $fieldGuid=null) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/fields?field={fieldGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($fieldGuid !== null) {
  		  $queryParams['field'] = $this->apiClient->toPathValue($fieldGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureFormDocumentFields
	 * Get form fields for document in form per participant
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (optional)
   * @return SignatureFormFieldsResponse
	 */

   public function GetSignatureFormDocumentFields($userId, $formGuid, $documentGuid, $fieldGuid=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/fields?field={fieldGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($fieldGuid !== null) {
  		  $queryParams['field'] = $this->apiClient->toPathValue($fieldGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureForm
	 * Get signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureFormResponse
	 */

   public function GetSignatureForm($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureForm
	 * Modify signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * body, SignatureFormSettingsInfo: Settings of the form (optional)
   * @return SignatureFormResponse
	 */

   public function ModifySignatureForm($userId, $formGuid, $body=null) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResponse');
  	  return $responseObject;
      }
  /**
	 * PublishSignatureForm
	 * Publish signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * body, WebhookInfo: Webhook Callback Url (optional)
   * @return SignatureStatusResponse
	 */

   public function PublishSignatureForm($userId, $formGuid, $body=null) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/publish");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * RenameSignatureForm
	 * Rename signature form
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * name, string: New form name (required)
   * @return SignatureFormResponse
	 */

   public function RenameSignatureForm($userId, $formGuid, $name) {
      if( $userId === null || $formGuid === null || $name === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}?new_name={name}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['new_name'] = $this->apiClient->toPathValue($name);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateSignatureFormFromTemplate
	 * Add signature form fields from template
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * templateGuid, string: Template GUID (required)
   * @return SignatureFormResponse
	 */

   public function UpdateSignatureFormFromTemplate($userId, $formGuid, $templateGuid) {
      if( $userId === null || $formGuid === null || $templateGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/templates/{templateGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($templateGuid !== null) {
  			$resourcePath = str_replace("{" . "templateGuid" . "}",
  			                            $templateGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureForms
	 * Get signature forms
   * userId, string: User GUID (required)
   * statusId, int: Filter forms by statusId (optional)
   * page, int: Show records for page number (optional)
   * records, int: Show records count (optional)
   * originalDocumentMD5, string: Filter forms by original document MD5 (optional)
   * DateTime, string: Filter forms by date (optional)
   * name, string: Filter forms by name (optional)
   * tag, string: Filter forms by tag (optional)
   * @return SignatureFormsResponse
	 */

   public function GetSignatureForms($userId, $statusId=null, $page=null, $records=null, $originalDocumentMD5=null, $DateTime=null, $name=null, $tag=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms?statusId={statusId}&records={records}&page={page}&document={originalDocumentMD5}&date={date}&name={name}&tag={tag}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($statusId !== null) {
  		  $queryParams['statusId'] = $this->apiClient->toPathValue($statusId);
  		}
  		if($page !== null) {
  		  $queryParams['page'] = $this->apiClient->toPathValue($page);
  		}
  		if($records !== null) {
  		  $queryParams['records'] = $this->apiClient->toPathValue($records);
  		}
  		if($originalDocumentMD5 !== null) {
  		  $queryParams['document'] = $this->apiClient->toPathValue($originalDocumentMD5);
  		}
  		if($DateTime !== null) {
  		  $queryParams['date'] = $this->apiClient->toPathValue($DateTime);
  		}
  		if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($tag !== null) {
  		  $queryParams['tag'] = $this->apiClient->toPathValue($tag);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureFormResources
	 * Get form resources
   * userId, string: User GUID (required)
   * statusIds, string: Form status identifier - comma separated list (required)
   * @return SignatureFormResourcesResponse
	 */

   public function GetSignatureFormResources($userId, $statusIds) {
      if( $userId === null || $statusIds === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/resources?statusIds={statusIds}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($statusIds !== null) {
  		  $queryParams['statusIds'] = $this->apiClient->toPathValue($statusIds);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResourcesResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignedFormDocuments
	 * Get signed form documents
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return stream
	 */

   public function GetSignedFormDocuments($userId, $formGuid, FileStream $outFileStream) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/documents/get");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * RenameSignatureFormDocument
	 * Rename signature form document
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Form Document GUID (required)
   * newName, string: New name of the document (optional)
   * @return SignatureFormDocumentResponse
	 */

   public function RenameSignatureFormDocument($userId, $formGuid, $documentGuid, $newName=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/document/{documentGuid}?newName={newName}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($newName !== null) {
  		  $queryParams['newName'] = $this->apiClient->toPathValue($newName);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * ModifySignatureFormDocument
	 * Modify signature form document
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Form Document GUID (required)
   * body, SignatureFormDocumentSettingsInfo: Settings of the document (optional)
   * @return SignatureFormDocumentResponse
	 */

   public function ModifySignatureFormDocument($userId, $formGuid, $documentGuid, $body=null) {
      if( $userId === null || $formGuid === null || $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/document/{documentGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * GetFormAuditLogs
	 * Get form audit logs
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureFormAuditLogsResponse
	 */

   public function GetFormAuditLogs($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/logs");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormAuditLogsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureFormParticipants
	 * Get form participants
   * userId, string: User GUID (required)
   * formGuid, string: Form GUID (required)
   * @return SignatureFormParticipantsResponse
	 */

   public function GetSignatureFormParticipants($userId, $formGuid) {
      if( $userId === null || $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/forms/{formGuid}/participants");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormParticipantsResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignaturePredefinedLists
	 * Get user predefined lists
   * userId, string: User GUID (required)
   * @return SignaturePredefinedListsResponse
	 */

   public function GetSignaturePredefinedLists($userId) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/lists");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignaturePredefinedListsResponse');
  	  return $responseObject;
      }
  /**
	 * AddPredefinedList
	 * Add predefined list
   * userId, string: User GUID (required)
   * body, SignaturePredefinedListSettingsInfo: List data (required)
   * @return SignaturePredefinedListResponse
	 */

   public function AddPredefinedList($userId, $body) {
      if( $userId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/list");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignaturePredefinedListResponse');
  	  return $responseObject;
      }
  /**
	 * DeletePredefinedList
	 * Delete predefined list
   * userId, string: User GUID (required)
   * listGuid, string: List GUID (required)
   * @return SignaturePredefinedListsResponse
	 */

   public function DeletePredefinedList($userId, $listGuid) {
      if( $userId === null || $listGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/lists/{listGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($listGuid !== null) {
  			$resourcePath = str_replace("{" . "listGuid" . "}",
  			                            $listGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignaturePredefinedListsResponse');
  	  return $responseObject;
      }
  /**
	 * GetRolesList
	 * Get signature roles
   * userId, string: User GUID (required)
   * roleGuid, string: Filter roles by GUID (optional)
   * @return SignatureRolesResponse
	 */

   public function GetRolesList($userId, $roleGuid=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/roles?id={roleGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($roleGuid !== null) {
  		  $queryParams['id'] = $this->apiClient->toPathValue($roleGuid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureRolesResponse');
  	  return $responseObject;
      }
  /**
	 * GetUserEmailTemplate
	 * Get user email template
   * userId, string: User GUID (required)
   * templateType, int: Template type (required)
   * @return stream
	 */

   public function GetUserEmailTemplate($userId, $templateType, FileStream $outFileStream) {
      if( $userId === null || $templateType === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/email-template/{templateType}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($templateType !== null) {
  			$resourcePath = str_replace("{" . "templateType" . "}",
  			                            $templateType, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * CreateSignature
	 * Create user signature
   * userId, string: User GUID (required)
   * name, string: Signature name (required)
   * body, SignatureSignatureSettingsInfo: Settings of the signature (optional)
   * @return SignatureSignatureResponse
	 */

   public function CreateSignature($userId, $name, $body=null) {
      if( $userId === null || $name === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/signature?name={name}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureSignatureResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteSignature
	 * Delete user signature
   * userId, string: User GUID (required)
   * signatureGuid, string: Signature GUID (required)
   * @return SignatureStatusResponse
	 */

   public function DeleteSignature($userId, $signatureGuid) {
      if( $userId === null || $signatureGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/signatures/{signatureGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($signatureGuid !== null) {
  			$resourcePath = str_replace("{" . "signatureGuid" . "}",
  			                            $signatureGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatures
	 * Get user signatures
   * userId, string: User GUID (required)
   * page, int: Show records for page number (optional)
   * records, int: Show records count (optional)
   * name, string: Filter by signature name (optional)
   * @return SignatureSignaturesResponse
	 */

   public function GetSignatures($userId, $page=null, $records=null, $name=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/{userId}/signatures?records={records}&page={page}&name={name}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($page !== null) {
  		  $queryParams['page'] = $this->apiClient->toPathValue($page);
  		}
  		if($records !== null) {
  		  $queryParams['records'] = $this->apiClient->toPathValue($records);
  		}
  		if($name !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($name);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureSignaturesResponse');
  	  return $responseObject;
      }
  /**
	 * PublicFillEnvelopeField
	 * Fill envelope field
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * body, stream: Data to be placed in field (optional)
   * @return SignatureEnvelopeFieldResponse
	 */

   public function PublicFillEnvelopeField($envelopeGuid, $documentGuid, $recipientGuid, $fieldGuid, $body=null) {
      if( $envelopeGuid === null || $documentGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldResponse');
  	  return $responseObject;
      }
  /**
	 * PublicSignEnvelope
	 * Sign envelope
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * body, SignatureSignEnvelopeSettingsInfo: Sign settings (optional)
   * @return SignatureStatusResponse
	 */

   public function PublicSignEnvelope($envelopeGuid, $recipientGuid, $body=null) {
      if( $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}/sign");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetEnvelopeDocuments
	 * Get documents in envelope
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return SignatureEnvelopeDocumentsResponse
	 */

   public function PublicGetEnvelopeDocuments($envelopeGuid, $recipientGuid) {
      if( $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}/documents");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeDocumentsResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetEnvelopeRecipients
	 * Get signature envelope recipients
   * envelopeGuid, string: Envelope GUID (required)
   * @return SignatureEnvelopeRecipientsResponse
	 */

   public function PublicGetEnvelopeRecipients($envelopeGuid) {
      if( $envelopeGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/recipients");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeRecipientsResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignatureEnvelopeFields
	 * Get signature field for document in envelope per recipient
   * envelopeGuid, string: Envelope GUID (required)
   * documentGuid, string: Document GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return SignatureEnvelopeFieldsResponse
	 */

   public function PublicGetSignatureEnvelopeFields($envelopeGuid, $documentGuid, $recipientGuid) {
      if( $envelopeGuid === null || $documentGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/fields?document={documentGuid}&recipient={recipientGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($documentGuid !== null) {
  		  $queryParams['document'] = $this->apiClient->toPathValue($documentGuid);
  		}
  		if($recipientGuid !== null) {
  		  $queryParams['recipient'] = $this->apiClient->toPathValue($recipientGuid);
  		}
  		if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignatureEnvelope
	 * Get signature envelope
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return SignatureEnvelopeResponse
	 */

   public function PublicGetSignatureEnvelope($envelopeGuid, $recipientGuid) {
      if( $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureEnvelopeResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignedEnvelopeDocuments
	 * Get signed envelope documents
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * @return stream
	 */

   public function PublicGetSignedEnvelopeDocuments($envelopeGuid, $recipientGuid, FileStream $outFileStream) {
      if( $envelopeGuid === null || $recipientGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}/documents/get");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * PublicFillSignatureForm
	 * Fill signature form
   * formGuid, string: Form GUID (required)
   * @return SignatureFormParticipantResponse
	 */

   public function PublicFillSignatureForm($formGuid) {
      if( $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/fill");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormParticipantResponse');
  	  return $responseObject;
      }
  /**
	 * PublicFillFormField
	 * Fill form field
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * fieldGuid, string: Field GUID (required)
   * authSignature, string: Authentication signature (required)
   * body, stream: Data to be placed in field (optional)
   * participantIdId, string: Participant GUID (required)
   * @return SignatureFormFieldResponse
	 */

   public function PublicFillFormField($formGuid, $documentGuid, $fieldGuid, $authSignature, $body=null, $participantIdId) {
      if( $formGuid === null || $documentGuid === null || $fieldGuid === null || $authSignature === null || $participantIdId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/documents/{documentGuid}/participant/{participantGuid}/field/{fieldGuid}?participantAuthSignature={authSignature}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($authSignature !== null) {
  		  $queryParams['participantAuthSignature'] = $this->apiClient->toPathValue($authSignature);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		if($participantIdId !== null) {
  			$resourcePath = str_replace("{" . "participantIdId" . "}",
  			                            $participantIdId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldResponse');
  	  return $responseObject;
      }
  /**
	 * PublicSignForm
	 * Sign Form
   * formGuid, string: Form GUID (required)
   * participantGuid, string: Participant GUID (required)
   * participantName, string: Participant Name (required)
   * authSignature, string: Authentication signature (required)
   * authData, stream: Base64 encoded Signer Image (optional)
   * body, SignatureSignFormSettingsInfo: Sign settings (optional)
   * @return SignatureStatusResponse
	 */

   public function PublicSignForm($formGuid, $participantGuid, $participantName, $authSignature, $authData=null, $body=null) {
      if( $formGuid === null || $participantGuid === null || $participantName === null || $authSignature === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/participant/{participantGuid}/sign?name={participantName}&participantAuthSignature={authSignature}&authData={authData}&signatureSignFormSettingsInfo={signatureSignFormSettingsInfo}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($participantName !== null) {
  		  $queryParams['name'] = $this->apiClient->toPathValue($participantName);
  		}
  		if($authSignature !== null) {
  		  $queryParams['participantAuthSignature'] = $this->apiClient->toPathValue($authSignature);
  		}
  		if($authData !== null) {
  		  $queryParams['authData'] = $this->apiClient->toPathValue($authData);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($participantGuid !== null) {
  			$resourcePath = str_replace("{" . "participantGuid" . "}",
  			                            $participantGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignatureForm
	 * Get signature form
   * formGuid, string: Form GUID (required)
   * @return SignatureFormResponse
	 */

   public function PublicGetSignatureForm($formGuid) {
      if( $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignatureFormDocuments
	 * Get documents in form
   * formGuid, string: Form GUID (required)
   * @return SignatureFormDocumentsResponse
	 */

   public function PublicGetSignatureFormDocuments($formGuid) {
      if( $formGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/documents");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormDocumentsResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignatureFormFields
	 * Get form fields for document in form per participant
   * formGuid, string: Form GUID (required)
   * documentGuid, string: Document GUID (required)
   * participantGuid, string: Participant GUID (required)
   * @return SignatureFormFieldsResponse
	 */

   public function PublicGetSignatureFormFields($formGuid, $documentGuid, $participantGuid) {
      if( $formGuid === null || $documentGuid === null || $participantGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/fields?document={documentGuid}&participant={participantGuid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($documentGuid !== null) {
  		  $queryParams['document'] = $this->apiClient->toPathValue($documentGuid);
  		}
  		if($participantGuid !== null) {
  		  $queryParams['participant'] = $this->apiClient->toPathValue($participantGuid);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignedFormDocuments
	 * Get signed form documents
   * formGuid, string: Form GUID (required)
   * participantGuid, string: Participant GUID (required)
   * @return stream
	 */

   public function PublicGetSignedFormDocuments($formGuid, $participantGuid, FileStream $outFileStream) {
      if( $formGuid === null || $participantGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/participant/{participantGuid}/documents/get");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($participantGuid !== null) {
  			$resourcePath = str_replace("{" . "participantGuid" . "}",
  			                            $participantGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetSignatureFormParticipant
	 * Get signature form participant
   * formGuid, string: Form GUID (required)
   * participantGuid, string: Participant GUID (required)
   * @return SignatureFormParticipantResponse
	 */

   public function GetSignatureFormParticipant($formGuid, $participantGuid) {
      if( $formGuid === null || $participantGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/participants/{participantGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($participantGuid !== null) {
  			$resourcePath = str_replace("{" . "participantGuid" . "}",
  			                            $participantGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormParticipantResponse');
  	  return $responseObject;
      }
  /**
	 * PublicSignDocument
	 * Sign document
   * documentGuid, string: Document GUID (required)
   * body, PublicSignatureSignDocumentSignerSettingsInfo: Settings of the signing document (optional)
   * @return SignatureSignDocumentResponse
	 */

   public function PublicSignDocument($documentGuid, $body=null) {
      if( $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/documents/{documentGuid}/sign");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureSignDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * PublicVerifyDocument
	 * Verify
   * body, stream: Document to verify (required)
   * @return SignatureVerifyDocumentResponse
	 */

   public function PublicVerifyDocument($body) {
      if( $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/verify");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureVerifyDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetSignDocumentStatus
	 * Get signed document status
   * jobGuid, string: Job GUID (required)
   * @return SignatureSignDocumentStatusResponse
	 */

   public function PublicGetSignDocumentStatus($jobGuid) {
      if( $jobGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/documents/{jobGuid}/status");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($jobGuid !== null) {
  			$resourcePath = str_replace("{" . "jobGuid" . "}",
  			                            $jobGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureSignDocumentStatusResponse');
  	  return $responseObject;
      }
  /**
	 * PublicGetDocumentFields
	 * Sign document
   * documentGuid, string: Document GUID (required)
   * @return SignatureDocumentFieldsResponse
	 */

   public function PublicGetDocumentFields($documentGuid) {
      if( $documentGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/documents/{documentGuid}/fields");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($documentGuid !== null) {
  			$resourcePath = str_replace("{" . "documentGuid" . "}",
  			                            $documentGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureDocumentFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * PublicModifyFormParticipant
	 * Update Form Participant
   * formGuid, string: Form GUID (required)
   * participantGuid, string: Participant GUID (required)
   * participantEmail, string: Participant Email to be set (required)
   * @return SignatureFormParticipantResponse
	 */

   public function PublicModifyFormParticipant($formGuid, $participantGuid, $participantEmail) {
      if( $formGuid === null || $participantGuid === null || $participantEmail === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/participant/{participantGuid}?email={participantEmail}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($participantEmail !== null) {
  		  $queryParams['email'] = $this->apiClient->toPathValue($participantEmail);
  		}
  		if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($participantGuid !== null) {
  			$resourcePath = str_replace("{" . "participantGuid" . "}",
  			                            $participantGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureFormParticipantResponse');
  	  return $responseObject;
      }
  /**
	 * PublicValidateFormParticipant
	 * Validate Particpiant Identity
   * formGuid, string: Form GUID (required)
   * participantGuid, string: Participant GUID (required)
   * validationCode, string: Code to be validated (required)
   * @return SignatureStatusResponse
	 */

   public function PublicValidateFormParticipant($formGuid, $participantGuid, $validationCode) {
      if( $formGuid === null || $participantGuid === null || $validationCode === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/participant/{participantGuid}/validationCode/{validationCode}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($participantGuid !== null) {
  			$resourcePath = str_replace("{" . "participantGuid" . "}",
  			                            $participantGuid, $resourcePath);
  		}
  		if($validationCode !== null) {
  			$resourcePath = str_replace("{" . "validationCode" . "}",
  			                            $validationCode, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * PublicFormParticipantResentValidationCode
	 * Request validation code email
   * formGuid, string: Form GUID (required)
   * participantGuid, string: Participant GUID (required)
   * @return SignatureStatusResponse
	 */

   public function PublicFormParticipantResentValidationCode($formGuid, $participantGuid) {
      if( $formGuid === null || $participantGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/forms/{formGuid}/participant/{participantGuid}/validationCode/resent");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($formGuid !== null) {
  			$resourcePath = str_replace("{" . "formGuid" . "}",
  			                            $formGuid, $resourcePath);
  		}
  		if($participantGuid !== null) {
  			$resourcePath = str_replace("{" . "participantGuid" . "}",
  			                            $participantGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SignatureStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSignatureEnvelopeFieldData
	 * Get signed envelope field data
   * envelopeGuid, string: Envelope GUID (required)
   * recipientGuid, string: Recipient GUID (required)
   * fieldGuid, string: Field GUID (required)
   * @return stream
	 */

   public function GetSignatureEnvelopeFieldData($envelopeGuid, $recipientGuid, $fieldGuid, FileStream $outFileStream) {
      if( $envelopeGuid === null || $recipientGuid === null || $fieldGuid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/envelopes/{envelopeGuid}/fields/recipient/{recipientGuid}/field/{fieldGuid}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($envelopeGuid !== null) {
  			$resourcePath = str_replace("{" . "envelopeGuid" . "}",
  			                            $envelopeGuid, $resourcePath);
  		}
  		if($recipientGuid !== null) {
  			$resourcePath = str_replace("{" . "recipientGuid" . "}",
  			                            $recipientGuid, $resourcePath);
  		}
  		if($fieldGuid !== null) {
  			$resourcePath = str_replace("{" . "fieldGuid" . "}",
  			                            $fieldGuid, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * PublicGetDefaultEmailTemplate
	 * Get default email template
   * templateType, int: Template type (required)
   * @return stream
	 */

   public function PublicGetDefaultEmailTemplate($templateType, FileStream $outFileStream) {
      if( $templateType === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/signature/public/email-template/{templateType}/default");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($templateType !== null) {
  			$resourcePath = str_replace("{" . "templateType" . "}",
  			                            $templateType, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  
}

