<?php
/**
 *  Copyright 2012 GroupDocs.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */
class PostApi {

	private $basePath = "https://api.groupdocs.com/v2.0";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

	public static function newInstance($apiClient) {
	  return new self($apiClient);
	}

    public function setBasePath($basePath) {
	  $this->basePath = $basePath;
	}
	  
	public function getBasePath() {
	  $this->basePath;
	}

  /**
	 * RenameByPost
	 * Rename by post
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * newName, string: New name (required)
   * @return RenameResponse
	 */

   public function RenameByPost($userId, $fileId, $newName) {
      if( $userId === null || $fileId === null || $newName === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/post/file.rename?user_id={userId}&file_id={fileId}&new_name={newName}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  		  $queryParams['user_id'] = $this->apiClient->toPathValue($userId);
  		}
  		if($fileId !== null) {
  		  $queryParams['file_id'] = $this->apiClient->toPathValue($fileId);
  		}
  		if($newName !== null) {
  		  $queryParams['new_name'] = $this->apiClient->toPathValue($newName);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'RenameResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteByPost
	 * Delete by post
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * @return DeleteResponse
	 */

   public function DeleteByPost($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/post/file.delete?user_id={userId}&file_id={fileId}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  		  $queryParams['user_id'] = $this->apiClient->toPathValue($userId);
  		}
  		if($fileId !== null) {
  		  $queryParams['file_id'] = $this->apiClient->toPathValue($fileId);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteFromFolderByPost
	 * Delete from folder by post
   * userId, string: User GUID (required)
   * path, string: Path (required)
   * @return DeleteResponse
	 */

   public function DeleteFromFolderByPost($userId, $path) {
      if( $userId === null || $path === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/post/file.delete.in?user_id={userId}&path={path}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  		  $queryParams['user_id'] = $this->apiClient->toPathValue($userId);
  		}
  		if($path !== null) {
  		  $queryParams['path'] = $this->apiClient->toPathValue($path);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteResponse');
  	  return $responseObject;
      }
  /**
	 * CompressByPost
	 * Compress by post
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * archiveType, string: Archive Type (required)
   * @return CompressResponse
	 */

   public function CompressByPost($userId, $fileId, $archiveType) {
      if( $userId === null || $fileId === null || $archiveType === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/post/file.compress?user_id={userId}&file_id={fileId}&archive_type={archiveType}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  		  $queryParams['user_id'] = $this->apiClient->toPathValue($userId);
  		}
  		if($fileId !== null) {
  		  $queryParams['file_id'] = $this->apiClient->toPathValue($fileId);
  		}
  		if($archiveType !== null) {
  		  $queryParams['archive_type'] = $this->apiClient->toPathValue($archiveType);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'CompressResponse');
  	  return $responseObject;
      }
  
}

